<?php
/**
 * Toolbox initialisation, using Systempay account informations
 * Required : ShopID + CERTIFICATE + platform URL
 */
$toolbox = require "config.php";

/**
 * Payment arguments
 * If none is mentioned, defaults will be used
 * You can check defaults and formats : vads-payment-php\lib\payzenFormToolbox.php  in function "getFormFields"
 */
if (floatvat($_POST['amount'])) {
  $amount = floatvat($_POST['amount']) * 100;
}
else {
  // error, payment can't be proceed
}

$args = array(
    "vads_amount" => $amount,//The amount of the transaction presented in the smallest unit of the currency (cents for Euro).
    "vads_currency" => "978", // An ISO 4217 numerical code of the payment currency.
    "vads_order_id" => $orderID,
    "vads_cust_first_name" => $firstName,
    "vads_cust_last_name" => $lastName,
    "vads_cust_phone" => $phoneNumber, 
    "vads_cust_email" => $email,
);

/**
 * Retrieve FORM DATA
 */
$formData = $toolbox->getFormData($args);

/**
 * Output the form in html
 */
$form = '<form action="'.$formData['form']['action'].'" method="'.$formData['form']['method'].'" accept-charset="'.$formData['form']['accept-charset'].'">';
  foreach ($formData['fields'] as $name => $value) {
    $form .= '<label for="'. $name. '">'.$name.'</label>';
    $form .= '<input type="text" readonly="readonly"  name="'.$name.'" value="'.$value.'" /><br />';
   }
  $form .= '<input type="submit" name="pay-submit" value="Payer"/>';
$form .= '</form>';

echo $form;
